//+------------------------------------------------------------------+
//|                                                LightGBM test.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#resource "\\Files\\lightgbm.eurusd.h1.onnx" as uchar lightgbm_onnx[]
#include <LightGBM.mqh>
#include <metrics.mqh>

CLightGBM lgb;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   if (!lgb.Init(lightgbm_onnx))
     return;
     
//--- custom out-of-sample testing 
   
   int bars = 9000;
   int start = 1000; 
   
   MqlRates rates_x[];
   ArraySetAsSeries(rates_x, true);
   int size = CopyRates(Symbol(), PERIOD_CURRENT, start, bars, rates_x); //We start at the bar 1000 and collect 9000 candles backward
   
   MqlRates rates_y[];
   ArraySetAsSeries(rates_y, true);
   CopyRates(Symbol(), PERIOD_CURRENT, start-1, bars, rates_y); //We do the same thing here but we only collect one bar forward making sure we get the prediction for the next candle
   
//---
   
   vector actual(size), predictions(size);
   for (int i=0; i<size; i++)
     {
       vector x = {
         rates_x[i].open,
         rates_x[i].high,
         rates_x[i].low,
         rates_x[i].close,
         rates_x[i].close-rates_x[i].open,
         rates_x[i].high-rates_x[i].low,
         rates_x[i].close-rates_x[i].low,
         rates_x[i].close-rates_x[i].high
       };
       
       actual[i] = rates_y[i].close > rates_x[i].open ? 1 : 0; //making the target variable
       predictions[i] = (double)lgb.predict_bin(x);
     }
   
   
   Metrics::classification_report(actual, predictions);
  }
//+------------------------------------------------------------------+
